<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2011 - 2022 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or Later
 */
defined('_JOLLYANY') or die;
define('JPATH_BASE', dirname(__DIR__));
require_once 'inc/data.php';
function get_data() {
    return JollyanyFrameworkDataImport::getData();
}
function get_all_tags() {
    $data       =   JollyanyFrameworkDataImport::getData();
    $filters    =   array();
    foreach ($data as $item) {
        $filters    =   array_merge($filters, $item['tags']);
    }
    return $filters;
}
function get_apiurl() {
    return JollyanyFrameworkDataImport::getApiUrl();
}
/**
 * Get license activation
 * @return string
 */
function get_license() {
    $lictext    =   '';
    $path       =   JPATH_BASE.'/media/jollyanykey';
    if (file_exists($path) && is_dir($path)) {
        $key = array();
        // Read the source directory
        if ($handle = @opendir($path)) {
            while (($file = readdir($handle)) !== false) {
                if ($file != '.' && $file != '..' && !\in_array($file, array('.svn', 'CVS', '.DS_Store', '__MACOSX'))) {
                    // Compute the fullpath
                    $fullpath = $path . '/' . $file;

                    if (!is_dir($fullpath) && preg_match("/.txt/", $file)) {
                        // Full path is requested
                        $key[] = $fullpath;
                    }
                }
            }
        }
        closedir($handle);
        if (count($key)) {
            $lictext    =   file_get_contents($key[0]);
        }
    }
    return $lictext;
}

function reset_license() {
    $path       =   JPATH_BASE.'/media/jollyanykey';
    if (file_exists($path) && is_dir($path)) {
        // Read the source directory
        if ($handle = @opendir($path)) {
            while (($file = readdir($handle)) !== false) {
                if ($file != '.' && $file != '..' && !\in_array($file, array('.svn', 'CVS', '.DS_Store', '__MACOSX'))) {
                    // Compute the fullpath
                    $fullpath = $path . '/' . $file;
                    if (!is_dir($fullpath) && preg_match("/.txt/", $file)) {
                        @unlink($fullpath);
                    }
                }
            }
        }
        closedir($handle);
    }
    return true;
}
/**
 * Unserialize value only if it was serialized.
 *
 * @since 2.0.0
 *
 * @param string $original Maybe unserialized original, if is needed.
 * @return mixed Unserialized data can be any type.
 */
function maybe_unserialize( $original ) {
    if ( is_serialized( $original ) ) { // don't attempt to unserialize data that wasn't serialized going in
        return @unserialize( $original );
    }
    return $original;
}

/**
 * Serialize data, if needed.
 *
 * @since 2.0.5
 *
 * @param string|array|object $data Data that might be serialized.
 * @return mixed A scalar data
 */
function maybe_serialize( $data ) {
    if ( is_array( $data ) || is_object( $data ) ) {
        return serialize( $data );
    }

    // Double serialization is required for backward compatibility.
    // See https://core.trac.wordpress.org/ticket/12930
    // Also the world will end. See WP 3.6.1.
    if ( is_serialized( $data, false ) ) {
        return serialize( $data );
    }

    return $data;
}

/**
 * Check value to find if it was serialized.
 *
 * If $data is not an string, then returned value will always be false.
 * Serialized data is always a string.
 *
 * @since 2.0.5
 *
 * @param string $data   Value to check to see if was serialized.
 * @param bool   $strict Optional. Whether to be strict about the end of the string. Default true.
 * @return bool False if not serialized and true if it was.
 */
function is_serialized( $data, $strict = true ) {
    // if it isn't a string, it isn't serialized.
    if ( ! is_string( $data ) ) {
        return false;
    }
    $data = trim( $data );
    if ( 'N;' == $data ) {
        return true;
    }
    if ( strlen( $data ) < 4 ) {
        return false;
    }
    if ( ':' !== $data[1] ) {
        return false;
    }
    if ( $strict ) {
        $lastc = substr( $data, -1 );
        if ( ';' !== $lastc && '}' !== $lastc ) {
            return false;
        }
    } else {
        $semicolon = strpos( $data, ';' );
        $brace     = strpos( $data, '}' );
        // Either ; or } must exist.
        if ( false === $semicolon && false === $brace ) {
            return false;
        }
        // But neither must be in the first X characters.
        if ( false !== $semicolon && $semicolon < 3 ) {
            return false;
        }
        if ( false !== $brace && $brace < 4 ) {
            return false;
        }
    }
    $token = $data[0];
    switch ( $token ) {
        case 's':
            if ( $strict ) {
                if ( '"' !== substr( $data, -2, 1 ) ) {
                    return false;
                }
            } elseif ( false === strpos( $data, '"' ) ) {
                return false;
            }
        // or else fall through
        case 'a':
        case 'O':
            return (bool) preg_match( "/^{$token}:[0-9]+:/s", $data );
        case 'b':
        case 'i':
        case 'd':
            $end = $strict ? '$' : '';
            return (bool) preg_match( "/^{$token}:[0-9.E-]+;$end/", $data );
    }
    return false;
}

/**
 * @description Make HTTP-POST call
 * @param       $url
 * @param       array $params
 * @return bool|HTTP-Response|string
 */
function HTTPPost($url, array $params) {
    $query = http_build_query($params);
    $ch    = curl_init();
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
    $response = curl_exec($ch);
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $result =   new stdClass();
    $headers = substr($response, 0, $header_size);
    $result->body = substr($response, $header_size);
    curl_close($ch);
    // Convert the $headers string to an indexed array
    $headers_indexed_arr = explode("\r\n", $headers);

    $headers_arr = array();

    foreach ($headers_indexed_arr as $value) {
        if(false !== ($matches = explode(':', $value, 2))) {
            $headers_arr["{$matches[0]}"] = trim($matches[1]);
        }
    }
    $result->headers    =   $headers_arr;
    return $result;
}

function getExt($file)
{
    // String manipulation should be faster than pathinfo() on newer PHP versions.
    $dot = strrpos($file, '.');

    if ($dot === false)
    {
        return '';
    }

    $ext = substr($file, $dot + 1);

    return $ext;
}