<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2009 - 2022 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */
defined('_JOLLYANY') or die;

class JollyanyFrameworkDataImport {
	protected static $api  =   'https://www.templaza.com';
    protected static $data =    null;

    public static function getTotalTemplate() {
        return count(self::getData());
    }

	public static function getApiUrl() {
		return self::$api;
	}

	public static function getData() {
	    self::$data   =   array(
            'astroid_kowalski'      =>  array(
                // Pack Info
                'name'        => 'Kowalski',
                'desc'        => 'Creative Portfolio Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/kowalski.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://kowalski.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/kowalski',

                'tags'        => [
                    'portfolio'   =>  'Portfolio',
                    'creative'        =>  'Creative',
                    'agency'        =>  'Agency',
                ]
            ),
            'astroid_nika'      =>  array(
                // Pack Info
                'name'        => 'Nika',
                'desc'        => 'AI Software Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/nika.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://nika.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/nika',

                'tags'        => [
                    'ai'   =>  'AI',
                    'creative'        =>  'Creative',
                    'agency'        =>  'Agency',
                ]
            ),
            'tz_kamper'      =>  array(
                // Pack Info
                'name'        => 'Kamper',
                'desc'        => 'Camping & Outdoor accommodation Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/kamper.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://kamper.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/kamper',
                'tags'        => [
                    'camping'   =>  'Camping',
                    'travel'        =>  'Travel',
                    'agency'        =>  'Agency',
                ]
            ),
            'tz_likeastar'      =>  array(
                // Pack Info
                'name'        => 'Like a Star',
                'desc'        => 'Creative Agency Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/likeastar.jpg',
                'category'    => 'joomla',

                'demo_url'    => 'https://likeastar.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/like-a-star',
                'tags'        => [
                    'photography'   =>  'Photography',
                    'booking'       =>  'Booking',
                    'travel'        =>  'Travel',
                    'agency'        =>  'Agency',
                ]
            ),
            'tz_travelami'      =>  array(
                // Pack Info
                'name'        => 'Travelami',
                'desc'        => 'Tour & Travel Booking Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/travelami.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://travelami.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/travelami',
                'tags'        => [
                    'tour'          =>  'Tour',
                    'booking'       =>  'Booking',
                    'travel'        =>  'Travel',
                    'agency'        =>  'Agency',
                ]
            ),
            'astroid_template_two'      =>  array(
                // Pack Info
                'name'        => 'Two',
                'desc'        => 'Free Astroid Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/two.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://demo.astroidframe.work/',
                'doc_url'     => 'https://docs.astroidframe.work/',
                'tags'        => [
                    'multipurpose'    =>  'Multi-purpose',
                    'astroid'     =>  'Astroid',
                ]
            ),
            'tz_probike'      =>  array(
                // Pack Info
                'name'        => 'ProBike',
                'desc'        => 'Bike Shop & Bicycle Rental Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/probike.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://probike.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/probike',
                'tags'        => [
                    'bicycle'       =>  'Bicycle',
                    'bike-shop'     =>  'Bike Shop',
                    'vehicle'       =>  'Vehicle',
                    'bike'          =>  'Bike',
                ]
            ),
            'tz_autobike'      =>  array(
                // Pack Info
                'name'        => 'Autobike',
                'desc'        => 'Motorcycle Store & Bike Rental Services Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/autobike.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://autobike.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/autobike',
                'tags'        => [
                    'automotive'    =>  'Automotive',
                    'motorbike'     =>  'Motorbike',
                    'vehicle'       =>  'Vehicle',
                    'bike'          =>  'Bike',
                ]
            ),
            'tz_express'      =>  array(
                // Pack Info
                'name'        => 'Express',
                'desc'        => 'Newspaper & News Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/express.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://express.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/express',
                'tags'        => [
                    'magazine'       =>  'Magazine',
                    'newspaper'      =>  'Newspaper',
                    'news-portal'    =>  'News Portal',
                    'blogger'       =>  'Blogger',
                ]
            ),
            'tz_amanus'      =>  array(
                // Pack Info
                'name'        => 'Amanus',
                'desc'        => 'Yacht Charter Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/amanus.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://amanus.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/amanus',
                'tags'        => [
                    'yacht-charter'      =>  'Yacht Charter',
                    'boat'      =>  'Boat',
                    'sailing'     =>  'Sailing',
                    'yacht'     =>  'Yacht',
                ]
            ),
            'tz_plazart'      =>  array(
                // Pack Info
                'name'        => 'Plazart',
                'desc'        => 'Construction Equipment Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/plazart.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://plazart.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/plazart',
                'tags'        => [
                    'building'      =>  'Building',
                    'construction'  =>  'Construction',
                    'equipment'     =>  'Equipment',
                ]
            ),
            'tz_todaynews'      =>  array(
                // Pack Info
                'name'        => 'Today News',
                'desc'        => 'Newspaper, Magazine & News Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/today-news.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://todaynews.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/today-news',
                'tags'        => [
                    'magazine'       =>  'Magazine',
                    'newspaper'      =>  'Newspaper',
                    'news-portal'    =>  'News Portal',
                    'blogger'       =>  'Blogger',
                ]
            ),
            'tz_interiart'      =>  array(
                // Pack Info
                'name'        => 'InteriArt',
                'desc'        => 'Furniture & Interior Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/interiart.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://interiart.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/interiart',
                'tags'        => [
                    'furniture'       =>  'Furniture',
                    'interior'        =>  'Interior',
                    'architect'   =>  'Architect',
                ]
            ),
            'tz_medil'      =>  array(
                // Pack Info
                'name'        => 'Medil',
                'desc'        => 'Medical & Healthcare Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/medil.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://medil.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/medil',
                'tags'        => [
                    'medical'       =>  'Medical',
                    'doctor'        =>  'Doctor',
                    'health-care'   =>  'Health Care',
                ]
            ),
            'tz_agruco'      =>  array(
                // Pack Info
                'name'        => 'Agruco',
                'desc'        => 'Agriculture & Organic Food Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/agruco.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://agruco.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/agruco',
                'tags'        => [
                    'agriculture'   =>  'Agriculture',
                    'organic-food'  =>  'Organic Food',
                    'farm'          =>  'Farm',
                ]
            ),
            'tz_oraz'      =>  array(
                // Pack Info
                'name'        => 'Oraz',
                'desc'        => 'Music Band Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/oraz.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://oraz.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/oraz',
                'tags'        => [
                    'music-band'    =>  'Music Band',
                    'producer'      =>  'Producer',
                    'singer'        =>  'Singer',
                ]
            ),
            'tz_goldenheart'      =>  array(
                // Pack Info
                'name'        => 'Golden Hearts',
                'desc'        => 'Fundraising & Charity Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/golden-hearts.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://goldenheart.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/goldenheart',
                'tags'        => [
                    'charity'       =>  'Charity',
                    'fundraising'   =>  'Fundraising',
                    'ngo'           =>  'NGO',
                ]
            ),
            'tz_organico'      =>  array(
                // Pack Info
                'name'        => 'Organico',
                'desc'        => 'Nutritionist Food & Farm Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/organico.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://organico.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/organico',
                'tags'        => [
                    'agriculture'   =>  'Agriculture',
                    'organic-food'  =>  'Organic Food',
                    'farm'          =>  'Farm',
                ]
            ),
            'tz_baressco'      =>  array(
                // Pack Info
                'name'        => 'Baressco',
                'desc'        => 'Wine & Vineyard Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/baressco.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://baressco.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/baressco',
                'tags'        => [
                    'wine'          =>  'Wine',
                    'vineyard'      =>  'Vineyard',
                    'winery'        =>  'Winery',
                ]
            ),
            'tz_powfit'      =>  array(
                // Pack Info
                'name'        => 'PowFit',
                'desc'        => 'Gym Fitness Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/powfit.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://powfit.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/powfit',
                'tags'        => [
                    'gym-fitness'       =>  'Gym Fitness',
                    'yoga-trainer'      =>  'Yoga Trainer',
                    'sport-clubs'       =>  'Sport Clubs',
                ]
            ),
            'tz_alex'      =>  array(
                // Pack Info
                'name'        => 'Alex',
                'desc'        => 'Portfolio Personal Blogger Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/alex.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://alex.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/alex',
                'tags'        => [
                    'blogger'       =>  'Blogger',
                    'personal'      =>  'Personal',
                    'resume'        =>  'Resume',
                ]
            ),
            'tz_lefala'      =>  array(
                // Pack Info
                'name'        => 'Lefala',
                'desc'        => 'Hikashop eCommerce Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/lefala.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://lefala.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/lefala',
                'tags'        => [
                    'company'       =>  'Company',
                    'ecommerce'      =>  'eCommerce',
                    'shop'        =>  'Shop',
                ]
            ),
            'tz_newspaper'      =>  array(
                // Pack Info
                'name'        => 'Newspaper',
                'desc'        => 'Magazine, Blog Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/newspaper.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://newspaper.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/newspaper',
                'tags'        => [
                    'magazine'       =>  'Magazine',
                    'newspaper'      =>  'Newspaper',
                    'news-portal'    =>  'News Portal',
                ]
            ),
            'tz_magazine'      =>  array(
                // Pack Info
                'name'        => 'Magazine',
                'desc'        => 'Blog, Newspaper Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/magazine.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://magazine.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/magazine',
                'tags'        => [
                    'magazine'       =>  'Magazine',
                    'newspaper'      =>  'Newspaper',
                    'blog'    =>  'Blog',
                ]
            ),
            'tz_varaham'      =>  array(
                // Pack Info
                'name'        => 'Varaham',
                'desc'        => 'Education University Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/varaham.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://varaham.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/varaham',
                'tags'        => [
                    'education'     =>  'Education',
                    'lms'           =>  'LMS',
                    'university'    =>  'University',
                ]
            ),
            'tz_krypton'      =>  array(
                // Pack Info
                'name'        => 'Krypton',
                'desc'        => 'Bitcoin Crypto Currency Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/krypton.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://krypton.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/krypton',
                'tags'        => [
                    'crypto'        =>  'Crypto',
                    'bitcoin'       =>  'Bitcoin',
                    'currency'      =>  'Currency',
                ]
            ),
            'tz_alita'      =>  array(
                // Pack Info
                'name'        => 'Alita',
                'desc'        => 'Web Studio & Creative Agency Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/alita.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://alita.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/alita',
                'tags'        => [
                    'web-design'     =>  'Web Design',
                    'marketing'      =>  'Marketing',
                    'portfolio'      =>  'Portfolio',
                ]
            ),
            'tz_martha'      =>  array(
                // Pack Info
                'name'        => 'Martha',
                'desc'        => 'Creative Portfolio Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/martha.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://martha.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/martha',
                'tags'        => [
                    'photography'     =>  'Photography',
                    'blogger'      =>  'Blogger',
                    'portfolio'      =>  'Portfolio',
                ]
            ),
            'tz_logistics'      =>  array(
                // Pack Info
                'name'        => 'Logistics',
                'desc'        => 'Cargo Transportation Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/logistics.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://logistics.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/logistics',
                'tags'        => [
                    'transportation' =>  'Transportation',
                    'logistics'      =>  'Logistics',
                    'corporate'      =>  'Corporate',
                ]
            ),
            'tz_pethub'      =>  array(
                // Pack Info
                'name'        => 'PetHub',
                'desc'        => 'Dog, Cat Care & Veterinary Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/pethub.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://pethub.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/pethub',
                'tags'        => [
                    'pet-care'      =>  'Pet Care',
                    'pet-services'  =>  'Pet Services',
                ]
            ),
            'tz_goldena'      =>  array(
                // Pack Info
                'name'        => 'GoldenA',
                'desc'        => 'Single Property Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/goldena.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://goldena.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/goldena',
                'tags'        => [
                    'single-property'   =>  'Single Property',
                    'real-estate'       =>  'Real Estate',
                ]
            ),
            'tz_educab'      =>  array(
                // Pack Info
                'name'        => 'Educab',
                'desc'        => 'University Education Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/educab.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://educab.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/educab',
                'tags'        => [
                    'education'     =>  'Education',
                    'e-learning'    =>  'E-Learning',
                    'lms'           =>  'LMS',
                ]
            ),
            'profiler-joomla-template'      =>  array(
                // Pack Info
                'name'        => 'Profiler',
                'desc'        => 'Personal Blog Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/profiler.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://profiler.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/profiler',
                'tags'        => [
                    'blogger'     =>  'Blogger',
                    'personal'    =>  'Personal',
                    'resume'      =>  'Resume',
                ]
            ),
            'tz_musika'      =>  array(
                // Pack Info
                'name'        => 'Musika',
                'desc'        => 'Music Band Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/musika.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://musika.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/musika',
                'tags'        => [
                    'festival'      =>  'Festival',
                    'music-band'    =>  'Music Band',
                    'event'         =>  'Event',
                ]
            ),
            'tz_jollyany'   =>  array(
                // Pack Info
                'name'        => 'Jollyany Classic',
                'desc'        => 'Multi-purpose, Business & Corporation',

                // Pack Data
                'thumb'       => 'assets/images/classic.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://jollyany.co/',
                'doc_url'     => 'https://jollyany.co/support/documentation',
                'tags'        => [
                    'corporation'   =>  'Corporation',
                    'business'      =>  'Business',
                    'organization'  =>  'Organization',
                ]
            ),
            'tz_everline_joomla'      =>  array(
                // Pack Info
                'name'        => 'Everline',
                'desc'        => 'Wedding Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/everline.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://everline.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/everline',
                'tags'        => [
                    'wedding'   =>  'Wedding',
                    'love'      =>  'Love',
                    'couples'   =>  'Couples',
                ]
            ),
            'tz_eventory_joomla'      =>  array(
                // Pack Info
                'name'        => 'Eventory',
                'desc'        => 'Festival, Event Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/eventory.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://eventory.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/eventory',
                'tags'        => [
                    'festival'      =>  'Festival',
                    'conference'    =>  'Conference',
                    'event'         =>  'Event',
                ]
            ),
            'tz_meetup'      =>  array(
                // Pack Info
                'name'        => 'Meetup',
                'desc'        => 'Conference Event Joomla Template',

                // Pack Data
                'thumb'       => 'assets/images/meetup.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://meetup.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/meetup',
                'tags'        => [
                    'meetup'        =>  'Meetup',
                    'conference'    =>  'Conference',
                    'event'         =>  'Event',
                ]
            ),
            'tz_new_age'      =>  array(
                // Pack Info
                'name'        => 'New Age',
                'desc'        => 'Creative Agency, Business, Company',

                // Pack Data
                'thumb'       => 'assets/images/new-age.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://newage.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/new-age',
                'tags'        => [
                    'business'      =>  'Business',
                    'agency'        =>  'Agency',
                    'startup'       =>  'Startup',
                ]
            ),
            'tz_nish_ii'   =>  array(
                // Pack Info
                'name'        => 'Nish II',
                'desc'        => 'Portfolio, Agency & Photography',

                // Pack Data
                'thumb'       => 'assets/images/nish-ii.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://nish2.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/nish_ii',
                'tags'        => [
                    'photography'       =>  'Photography',
                    'agency'            =>  'Agency',
                    'portfolio'         =>  'Portfolio',
                ]
            ),
            'tz_fashion_semona_joomla'      =>  array(
                // Pack Info
                'name'        => 'Fashion',
                'desc'        => 'Model Agency, Photography',

                // Pack Data
                'thumb'       => 'assets/images/fashion.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://fashion.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/fashion',
                'tags'        => [
                    'photography'       =>  'Photography',
                    'agency'            =>  'Agency',
                    'model'             =>  'Model',
                ]
            ),
            'tz_lawyer'    =>  array(
                // Pack Info
                'name'        => 'Lawyer Justice',
                'desc'        => 'Lawyers Attorneys and Law Firm',

                // Pack Data
                'thumb'       => 'assets/images/lawyer-justice.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://justice.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/lawyer-justice',
                'tags'        => [
                    'lawyers'       =>  'Lawyers',
                    'attorneys'     =>  'Attorneys',
                    'law-firm'      =>  'Law Firm',
                ]
            ),
            'tz_charity_joomla'    =>  array(
                // Pack Info
                'name'        => 'Charity',
                'desc'        => 'Non-profit, NGO & Fundraising',

                // Pack Data
                'thumb'       => 'assets/images/charity.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://charity.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/charity',
                'tags'        => [
                    'ngo'           =>  'NGO',
                    'fundraising'   =>  'Fundraising',
                    'nonprofit'     =>  'Nonprofit',
                    'charity'       =>  'Charity',
                ]
            ),
            'tz_foodz_joomla'      =>  array(
                // Pack Info
                'name'        => 'Foodz',
                'desc'        => 'Restaurant, Receipt & Bakery',

                // Pack Data
                'thumb'       => 'assets/images/foodz.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://foodz.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/foodz',
                'tags'        => [
                    'restaurant'    =>  'Restaurant',
                    'bakery'        =>  'Bakery',
                    'cafe'          =>  'Cafe',
                ]
            ),
            'tz_construction'      =>  array(
                // Pack Info
                'name'        => 'Construction',
                'desc'        => 'Building, Construction & Architect',

                // Pack Data
                'thumb'       => 'assets/images/construction.jpeg',
                'category'    => 'joomla',

                'demo_url'    => 'https://construction.jollyany.co/',
                'doc_url'     => 'https://docs.jollyany.co/templates/construction/',
                'tags'        => [
                    'building'      =>  'Building',
                    'construction'  =>  'Construction',
                    'architect'     =>  'Architect',
                ]
            ),
        );
		return self::$data;
	}
}
