<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2011 - 2022 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or Later
 */
defined('_JOLLYANY') or die;
$templates  =   get_data();
$api_url    =   JollyanyFrameworkDataImport::getApiUrl();
$filters    =   get_all_tags();
?>
<div class="uk-section uk-section-default uk-flex uk-flex-middle uk-text-center">
    <div class="uk-container uk-container-small">
        <h1 class="uk-heading-small">Jollyany Installation</h1>
        <p class="uk-margin-medium uk-text-lead">
            Jollyany is trusted by 1300+ people worldwide. Explore our collection of <?php echo count($templates); ?>+ projects created by a team of professional designers. Our products are perfect for business, ecommerce, blog and personal websites.
        </p>
    </div>
</div>
<div class="uk-section uk-section-default">
    <div class="uk-container uk-container-expand">
        <div class="uk-grid-large uk-grid" data-uk-filter="target: #jollyanyItems; animation: fade">
            <div class="uk-visible@m uk-first-column">
                <div class="uk-width-small">
                    <ul class="uk-nav uk-nav-default">
                        <li uk-filter-control="group: topic" class="uk-active"><a href="">All</a></li>
                        <?php foreach ($filters as $key => $filter) : ?>
                            <li uk-filter-control="filter: [data-topic*='<?php echo $filter; ?>']; group: topic"><a href=""><?php echo $filter; ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <div class="uk-width-expand@m">
                <div id="jollyanyItems" class="uk-child-width-1-3@xl uk-child-width-1-2@l uk-child-width-1-1@m uk-child-width-1-2@s uk-child-width-1-1 uk-grid-large" uk-grid>
                    <?php
                    foreach ($templates as $key => $template) :
                        ?>
                        <div class="item uk-card" data-topic="<?php echo implode(' ', $template['tags']); ?>">
                            <div class="uk-position-relative uk-transition-toggle uk-inline">
                                <div class="image uk-box-shadow-medium">
                                    <img data-src="<?php echo $template['thumb'] ?>" data-width="590" data-height="555" uk-img />
                                </div>
                                <div class="uk-position-cover uk-overlay uk-overlay-default uk-transition-fade"></div>
                                <div class="tz-cta uk-panel uk-position-center uk-text-center uk-transition-fade">
                                    <p>
                                        <a class="uk-button uk-button-secondary uk-button-large uk-button-round uk-width-small uk-border-pill" href="<?php echo $template['demo_url']; ?>" target="_blank">Preview</a>
                                    </p>
                                    <p>
                                        <a class="uk-button uk-button-primary uk-button-large uk-button-round uk-width-small uk-border-pill jollyany-install" data-name="<?php echo $template['name']; ?>" data-file="<?php echo $key; ?>" href="#jollyany-modal" uk-toggle>Install</a>
                                    </p>
                                </div>
                            </div>
                            <div class="uk-card-body uk-padding-remove-horizontal">
                                <a class="uk-link-heading jollyany-install" data-name="<?php echo $template['name']; ?>" data-file="<?php echo $key; ?>" href="#jollyany-modal" uk-toggle><h3 class="uk-card-title uk-margin-small"><?php echo $template['name']; ?></h3></a>
                                <p class="uk-text-meta uk-margin-small"><?php echo $template['desc']; ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="jollyany-modal" class="uk-flex-top" uk-modal>
    <div class="uk-modal-dialog uk-margin-auto-vertical">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Install <span class="template-name"></span></h2>
        </div>
        <div class="uk-modal-body">
            <p>It's like you install the quickstart package. It includes all template features and medias. Refer to <a href="https://vimeo.com/652749141" target="_blank">this video tutorial to understand</a>.</p>
            <p><em>NOTICE: You need to prepare your SQL username and password. In the last step, you have to re-enter your admin password.</em></p>
            <div class="dialogDebug"></div>
        </div>
        <div class="uk-modal-footer">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button" id="install-action" data-file="" data-name="">Install</button>
            <a href="https://docs.jollyany.co/getting-started/how-to-download-templates" class="uk-button uk-button-danger" target="_blank">Can't download</a>
        </div>
    </div>
</div>