<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2011 - 2022 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or Later
 */
defined('_JOLLYANY') or die;
$time_limit = ini_get( 'max_execution_time' );
?>
<div class="uk-section uk-section-default uk-flex uk-flex-middle uk-text-center">
    <div class="uk-container uk-container-small">
        <h1 class="uk-heading-small">System Requirement</h1>
        <p class="uk-margin-medium uk-text-lead">
            Your server system is not ready!
        </p>
    </div>
</div>
<div class="uk-section uk-section-default">
    <div class="uk-container uk-container-xsmall">
        <div class="uk-card uk-card-default uk-card-body">
            <h3 class="uk-card-title uk-margin-remove-bottom">System Requirement</h3>
            <ul class="uk-list uk-list-divider">
                <li class="<?php echo extension_loaded('curl') ? 'uk-text-success' : 'uk-text-danger'; ?>"><span uk-icon="<?php echo extension_loaded('curl') ? 'check' : 'close'; ?>"></span> CURL is <?php echo extension_loaded('curl') ? 'installed' : 'not installed'; ?></li>
                <li class="<?php echo extension_loaded('zip') ? 'uk-text-success' : 'uk-text-danger'; ?>"><span uk-icon="<?php echo extension_loaded('zip') ? 'check' : 'close'; ?>"></span> ZipArchive library is <?php echo extension_loaded('zip') ? 'installed' : 'not installed'; ?></li>
                <li class="<?php echo ini_get('allow_url_fopen') ? 'uk-text-success' : 'uk-text-danger'; ?>"><span uk-icon="<?php echo ini_get('allow_url_fopen') ? 'check' : 'close'; ?>"></span> allow_url_fopen is <?php echo ini_get('allow_url_fopen') ? 'On' : 'Off'; ?></li>
                <li><span uk-icon="check"></span> PHP Max Input Vars: <?php echo ini_get('max_input_vars'); ?></li>
                <li class="<?php echo 180 > $time_limit && 0 != $time_limit ? 'uk-text-danger' : 'uk-text-success'; ?>"><span uk-icon="<?php echo 180 > $time_limit && 0 != $time_limit ? 'close' : 'check'; ?>"></span> PHP Time Limit: <?php echo ini_get('max_execution_time'); ?><?php echo 180 > $time_limit && 0 != $time_limit? ' (Recommend >=180)' : ''; ?></li>
            </ul>
            <div class="uk-margin-medium"><a href="https://docs.jollyany.co/getting-started/how-to-download-templates" class="uk-button uk-button-danger" target="_blank">If you have problem with download package</a></div>
        </div>
    </div>
</div>
