<?php
/**
 * @package   Jollyany Framework
 * @author    TemPlaza https://www.templaza.com
 * @copyright Copyright (C) 2011 - 2022 TemPlaza.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or Later
 */
defined('_JOLLYANY') or die;
?>
<div class="uk-section uk-section-default uk-flex uk-flex-middle uk-text-center">
    <div class="uk-container uk-container-small">
        <h1 class="uk-heading-small">Active your Jollyany license</h1>
        <p class="uk-margin-medium uk-text-lead">
            Purchase & activate Jollyany Package to get all template of Jollyany family, demo content, template support, patches and latest updates including premium extensions bundled.
        </p>
    </div>
</div>
<div class="uk-section uk-section-default">
    <div class="uk-container uk-container-small">
        <div class="uk-child-width-1-2@m" uk-grid>
            <div>
                <div class="uk-card uk-card-default uk-card-body">
                    <h3 class="uk-card-title uk-margin-remove-bottom">Benefit</h3>
                    <p class="uk-text-meta uk-margin-remove-top">Paid only once <span class="uk-badge"><del>$1289</del> -> <strong>$79</strong></span></p>
                    <p>If you haven't purchased Jollyany, <a href="https://1.envato.market/jollyany-joomla-package" target="_blank"><strong>click here to buy a license</strong></a> and activate template.</p>
                    <ul class="uk-list uk-list-divider">
                        <li><span uk-icon="check"></span> All Jollyany templates</li>
                        <li><span uk-icon="check"></span> <?php echo count(get_data()); ?>+ Joomla Templates</li>
                        <li><span uk-icon="check"></span> 6 Months Support</li>
                        <li><span uk-icon="check"></span> Lifetime Usage</li>
                        <li><span uk-icon="check"></span> Lifetime Update in 1 valid domain</li>
                        <li><span uk-icon="check"></span> Copyright removal</li>
                        <li><span uk-icon="check"></span> 40% Renewal Discount</li>
                        <li><span uk-icon="check"></span> SP Page Builder Pro Included</li>
                        <li><span uk-icon="check"></span> TZ Portfolio Pro Personal License</li>
                    </ul>
                    <div class="uk-margin-medium-top"><a href="https://1.envato.market/jollyany-joomla-package" target="_blank" class="uk-button uk-button-primary uk-width-1-1"><span uk-icon="cart"></span> Click here to buy a license</a></div>
                </div>
            </div>
            <div>
                <div class="uk-card uk-card-primary uk-card-body">
                    <h3>You have a Jollyany license</h3>
                    <p>Template activation process is automatic, you need to enter purchase code manually. Follow these steps to activate the template</p>
                    <ul class="uk-list uk-list-decimal uk-list-divider">
                        <li>Click Activate Package button</li>
                        <li>You will be asked to login with your Envato account (used to purchase this template) to authorize template purchase code</li>
                        <li>Choose one of valid purchase codes from the list and click Proceed</li>
                        <li>Product is activated and you can get latest updates!</li>
                    </ul>
                    <div class="uk-margin-medium-top"><button id="jollyany-theme-activate" class="uk-button uk-button-primary uk-width-1-1"><span uk-icon="check"></span> Click here to Active Package</button></div>
                    <div class="uk-margin"><a href="https://docs.jollyany.co/getting-started/how-to-download-templates" class="uk-button uk-button-danger uk-width-1-1" target="_blank"><span uk-icon="cloud-download"></span> I have an issue when active</a></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
if ($_SERVER['HTTP_HOST'] === 'localhost') {
    $client_url = '//' . $_SERVER['HTTP_HOST']. $_SERVER['REQUEST_URI'];
} else {
    $client_url = $_SERVER["SCRIPT_URI"];
}
$key            =   md5(uniqid('Jollyany'));
$javascript =   json_encode( array(
    // Request product activation
    'action'   => 'activate-product',

    // Jollyany API site url to go for activation
    'api'      => get_apiurl(),

    // Jollyany Itemid
    'envatoid' => 8596818,

    // Jollyany Itemid
    'productname' => 'Jollyany',

    // URL to activate license for
    'url'      => $client_url,

    // URL to return back data
    'callback_url'      => $client_url.'?jollyany=activation&key='.$key
) );
$path       =   JPATH_BASE.'/media/jollyanykey';
if (!file_exists($path)) {
    if (!file_exists(JPATH_BASE.'/media')) {
        $origmask = @umask(0);
        // Create the path
        if (!$ret = @mkdir(JPATH_BASE.'/media', 0755))
        {
            @umask($origmask);
            return false;
        }

        // Reset umask
        @umask($origmask);
    }
    $origmask = @umask(0);
    // Create the path
    if (!$ret = @mkdir($path, 0755))
    {
        @umask($origmask);
        return false;
    }

    // Reset umask
    @umask($origmask);
}
file_put_contents($path . '/' . $key . '.txt', $javascript);
echo '<script id="jollyany-form-data-json" type="text/template">'.$javascript.'</script>';